# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 9
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial Rounds (1-3)
    if current_round <= 3:
        if current_round == 1:
            return "C"
        else:
            if "D" in opp_history[:current_round-1]:
                return "D"
            else:
                return "C"
    
    # Middle Rounds (4-7)
    elif 4 <= current_round <= 7:
        if "D" in opp_history[:3]:
            return opp_history[-1]
        else:
            if "D" in opp_history[3:current_round-1]:
                return opp_history[-1]
            else:
                return "C"
    
    # Final Rounds (8-10)
    else:
        if opp_history.count("D") > opp_history.count("C"):
            return "D"
        else:
            return "C"